#!/bin/sh
#
# Uninstall AntiVir for UNIX
#
# Copyright (c) 2015 Avira Operations GmbH & Co. KG and its Licensors
#

if [[ "$(whoami)" != "root" ]] ; then
    sudo "$0"
    exit $?
fi

# set default variable values
OS=`uname | env LANG=C LC_ALL=C LC_CTYPE=C tr '[:upper:]' '[:lower:]'`
AVDIR_BASE="/Applications/Avira.app/Contents"
AGENTDIR_BASE="/opt/avira"
UTILITIES_BASE="/Applications/Utilities/Avira"
UTILITIES_DIR="${UTILITIES_BASE}/Contents/MacOS"
AVSTATS="/Applications/Utilities/Avira-Uninstall.app/Contents/MacOS/AvStats"
LAUNCHADIR="/Library/LaunchAgents"
LAUNCHDDIR="/Library/LaunchDaemons"
AVDIR="${AVDIR_BASE}"
BACKUPDIR="/var/backups/avira"
AVIRA_SUPPORT="/Library/Application Support/Avira"
FULLPRODUCTNAME="Avira Antivirus"
AVDIR="${AVDIR_BASE}/guard"
PRODUCT_BIN="${AVDIR}/avguard.bin"
GUARD_INSTALLED="1"
COMPACT_LIST="0"
SILENCE="0"
PROCESS_FOUND="0"
KEY_FOUND="0"
AGENT_INSTALLED="0"
GUARD_INSTALLED="0"
KEEP_QUARANTINE="0"
MANUAL_UNINSTALLATION="0"

SMC_PLUGIN=""
RCSCRIPT=""
RCDIR=""
SYSTEM=""
MAIN_CONF_FILES=""


root_check()
{
	ID=`id`
	CUT=`echo $ID | sed -e 's,uid=0(,,'`
	if [ "$CUT" = "$ID" ]
	then
		CUT=`echo $ID | sed -e 's,\euid=0(,,'`
		if [ "$CUT" = "$ID" ]
		then
			echo " "
			echo "This script must be run as root."
			echo " "
			exit 0
		fi
	fi
}


shutdown_gui()
{
	echo "shutting down the GUI ... "
	killall Avira
}


shutdown_scheduler()
{
	echo "shutting down the Scheduler GUI ... "
	killall AV_Scheduler
}


remove_launcha_entries()
{
	LOGGED_ON_USER=$(stat -f%Su /dev/console)
	AGENT_PLIST=$(ls $LAUNCHADIR/*avira*)

	for PLIST_ITEM in $AGENT_PLIST; do
		if [ -f $PLIST_ITEM ]; then
			PLIST_FILE=$(echo $PLIST_ITEM | sed -e 's,.*\/,,' -e 's,.plist,,')
			if sudo su - ${LOGGED_ON_USER} -c 'launchctl list | grep '$PLIST_FILE'' > /dev/null 2>&1; then
				echo "unloading $PLIST_ITEM for user ${LOGGED_ON_USER} ... "
				sudo su - ${LOGGED_ON_USER} -c 'launchctl unload '$PLIST_ITEM'' > /dev/null 2>&1
			fi

			if [ -f $PLIST_ITEM ]; then rm $PLIST_ITEM > /dev/null 2>&1; fi
		fi
	done
}


remove_launchd_entries()
{
	DAEMON_PLIST=$(ls $LAUNCHDDIR/*avira*)

	for PLIST_ITEM in $DAEMON_PLIST; do
		if [ -f "$PLIST_ITEM" ]; then
			PLIST_FILE=$(echo $PLIST_ITEM | sed -e 's,.*\/,,' -e 's,.plist,,')
			if launchctl list | grep $PLIST_FILE > /dev/null 2>&1; then
				echo "unloading ${PLIST_ITEM} ... "
				launchctl unload $PLIST_ITEM > /dev/null 2>&1
			fi

			if [ -f $PLIST_ITEM ]; then rm $PLIST_ITEM > /dev/null 2>&1; fi
		fi
	done
}


check_for_remaining_processes()
{
	for IMPORTANT_PROCESSES in ${AVDIR_BASE}/MacOS/AV_Systray.app/Contents/MacOS/AV_Systray \
				   ${AVDIR_BASE}/MacOS/AV_Scheduler_Ex \
				   ${AVDIR_BASE}/eprocsd/eprocsd \
				   ${AVDIR_BASE}/guard/avguard.bin \
				   ${AVDIR_BASE}/guard/avguard-scanner \
				   ${AVDIR_BASE}/guard/avsavapi-super \
				   ${AVDIR_BASE}/guard/avguard-ondemand-mgmt \
				   ${AVDIR_BASE}/MacOS/avqmd \
				   ${AVDIR_BASE}/MacOS/avlogwriter \
				   ${AVDIR_BASE}/MacOS/avbackendproxy \
				   AV_Scheduler_Ex \
				   eprocsd \
				   avguard.bin \
				   avguard-scanner \
				   avsavapi-super \
				   avguard-ondemand-mgmt \
				   avqmd \
				   avlogwriter \
				   avbackendproxy
	do
		KILL_TIMEOUT="10"
		PRODUCT_PID=""

		PRODUCT_PID=$(ps ax | grep -v grep | grep ${IMPORTANT_PROCESSES} | awk -F' ' '{ print $1 }')
		if [ ! -z "${PRODUCT_PID}" ]
		then
			echo "WARNING: ${IMPORTANT_PROCESSES} is still running."
			echo "trying to shutdown the process ..."

			for KILLING in ${PRODUCT_PID}; do kill -TERM ${KILLING} > /dev/null 2>&1; done

			while [ "${KILL_TIMEOUT}" -gt "0" ]
			do
				ps ax | grep -v grep | grep ${IMPORTANT_PROCESSES} > /dev/null 2>&1
				if [ "${?}" -ne "0" ]
				then
					break
				fi

				sleep 1
				KILL_TIMEOUT=`expr ${KILL_TIMEOUT} - 1`
			done

			if [ "${KILL_TIMEOUT}" -eq "0" ]
			then
				for KILLING in ${PRODUCT_PID}; do kill -KILL ${KILLING} > /dev/null 2>&1; done
			fi
		fi
	done
}


remove_db_receipts()
{
	echo "removing ${FULLPRODUCTNAME} Database receipts ... "
#	remove db receipts of the installed package
	if [ -d "/private/var/db/receipts" ]
	then
		rm /private/var/db/receipts/*.Avira* > /dev/null 2>&1
	fi
}


remove_crash_reports()
{
	echo "removing ${FULLPRODUCTNAME} crash reports ... "
#	remove all avira crash reports for in all found User directories

	for SYSTEM_USERS in `ls /Users`
	do
		REPORT_LOCATION="/Users/${SYSTEM_USERS}/Library/Logs/CrashReporter"
		if [ -d "$REPORT_LOCATION" ]; then
			rm "$REPORT_LOCATION"/Avira* > /dev/null 2>&1
			rm "$REPORT_LOCATION"/avbackendproxy* > /dev/null 2>&1
			rm "$REPORT_LOCATION"/avlogwriter* > /dev/null 2>&1
			rm "$REPORT_LOCATION"/schedule* > /dev/null 2>&1
			rm "$REPORT_LOCATION"/avguard* > /dev/null 2>&1
			rm "$REPORT_LOCATION"/uxipm* > /dev/null 2>&1
			rm "$REPORT_LOCATION"/uxipm* > /dev/null 2>&1
			rm "$REPORT_LOCATION"/Avira-Uninstall_* > /dev/null 2>&1
			rm "$REPORT_LOCATION"/AV_Scheduler* > /dev/null 2>&1
			rm "$REPORT_LOCATION"/AV_Systray* > /dev/null 2>&1
			rm "$REPORT_LOCATION"/avqmd* > /dev/null 2>&1
			rm "$REPORT_LOCATION"/avrtp* > /dev/null 2>&1
		fi

		REPORT_LOCATION="/Users/${SYSTEM_USERS}/Library/Application Support/CrashReporter"
		if [ -d "$REPORT_LOCATION" ]; then
			rm "$REPORT_LOCATION"/Avira* > /dev/null 2>&1
			rm "$REPORT_LOCATION"/avbackendproxy* > /dev/null 2>&1
			rm "$REPORT_LOCATION"/avlogwriter* > /dev/null 2>&1
			rm "$REPORT_LOCATION"/schedule* > /dev/null 2>&1
			rm "$REPORT_LOCATION"/avguard* > /dev/null 2>&1
			rm "$REPORT_LOCATION"/uxipm* > /dev/null 2>&1
			rm "$REPORT_LOCATION"/Avira-Uninstall_* > /dev/null 2>&1
			rm "$REPORT_LOCATION"/AV_Scheduler* > /dev/null 2>&1
			rm "$REPORT_LOCATION"/AV_Systray* > /dev/null 2>&1
			rm "$REPORT_LOCATION"/avqmd* > /dev/null 2>&1
			rm "$REPORT_LOCATION"/avrtp* > /dev/null 2>&1
		fi
	done

	REPORT_LOCATION="/Library/Application Support/CrashReporter"
	if [ -d "$REPORT_LOCATION" ]; then
		rm "$REPORT_LOCATION"/Avira* > /dev/null 2>&1
		rm "$REPORT_LOCATION"/avbackendproxy* > /dev/null 2>&1
		rm "$REPORT_LOCATION"/avlogwriter* > /dev/null 2>&1
		rm "$REPORT_LOCATION"/schedule* > /dev/null 2>&1
		rm "$REPORT_LOCATION"/avguard* > /dev/null 2>&1
		rm "$REPORT_LOCATION"/uxipm* > /dev/null 2>&1
		rm "$REPORT_LOCATION"/Avira-Uninstall_* > /dev/null 2>&1
		rm "$REPORT_LOCATION"/AV_Scheduler* > /dev/null 2>&1
		rm "$REPORT_LOCATION"/AV_Systray* > /dev/null 2>&1
		rm "$REPORT_LOCATION"/avqmd* > /dev/null 2>&1
		rm "$REPORT_LOCATION"/avrtp* > /dev/null 2>&1
	fi

	REPORT_LOCATION="/Library/Logs/DiagnosticReports"
	if [ -d "$REPORT_LOCATION" ]; then
		rm "$REPORT_LOCATION"/Avira* > /dev/null 2>&1
		rm "$REPORT_LOCATION"/avbackendproxy* > /dev/null 2>&1
		rm "$REPORT_LOCATION"/avlogwriter* > /dev/null 2>&1
		rm "$REPORT_LOCATION"/schedule* > /dev/null 2>&1
		rm "$REPORT_LOCATION"/avguard* > /dev/null 2>&1
		rm "$REPORT_LOCATION"/uxipm* > /dev/null 2>&1
		rm "$REPORT_LOCATION"/Avira-Uninstall_* > /dev/null 2>&1
		rm "$REPORT_LOCATION"/AV_Scheduler* > /dev/null 2>&1
		rm "$REPORT_LOCATION"/AV_Systray* > /dev/null 2>&1
		rm "$REPORT_LOCATION"/avqmd* > /dev/null 2>&1
		rm "$REPORT_LOCATION"/avrtp* > /dev/null 2>&1
	fi
}


remove_diagnostic_reports()
{
	echo "removing ${FULLPRODUCTNAME} diagnostic reports ... "
#	remove all avira crash reports for in all found User directories
	for SYSTEM_USERS in `ls /Users`
	do
		if [ -d "${SYSTEM_USERS}/Library/Logs/DiagnosticReports" ]
		then
			rm ${SYSTEM_USERS}/Library/Logs/DiagnosticReports/Avira* > /dev/null 2>&1
			rm ${SYSTEM_USERS}/Library/Logs/DiagnosticReports/avbackendproxy* > /dev/null 2>&1
			rm ${SYSTEM_USERS}/Library/Logs/DiagnosticReports/avlogwriter* > /dev/null 2>&1
			rm ${SYSTEM_USERS}/Library/Logs/DiagnosticReports/schedule* > /dev/null 2>&1
		fi
	done
}


remove_private_files()
{
	for PRODUCT_PID_FILES in `ls /private/var/run | grep avira | grep -v avira_management_console_agent.pid`
	do
		rm /private/var/run/${PRODUCT_PID_FILES} > /dev/null 2>&1
	done
	rm -r /private/var/run/.com.avira.* > /dev/null 2>&1
}


f_remove_update_files()
{
	rm /var/run/avupdate.lock > /dev/null 2>&1
}


remove_quarantine_dir()
{
	rm -r /var/run/avqmd > /dev/null 2>&1

	if [ "${KEEP_QUARANTINE}" -eq "1" ]
	then
		return 0
	fi

	echo "remove quarantine directory ... "
	rm -r /Library/Application\ Support/Avira/Quarantine > /dev/null 2>&1
}


remove_logwriter_dir()
{
	echo "remove logwriter directory ... "
	rm -r /Library/Application\ Support/Avira/Logwriter > /dev/null 2>&1
	rm -r /var/run/com.avira.antivirus.logwriter > /dev/null 2>&1
}


remove_avwl_dir()
{
	echo "remove avwl directory ... "
	rm -r /Library/Application\ Support/Avira/Whitelist > /dev/null 2>&1
}


remove_update_dir()
{
	echo "remove update directory ... "
	rm -r /Library/Application\ Support/Avira/Update > /dev/null 2>&1
	rm -r /tmp/uxupdate.tmp.* > /dev/null 2>&1
}


remove_ipm_dir()
{
	echo "remove ipm directory ... "
	rm -r /Library/Application\ Support/Avira/IPM > /dev/null 2>&1
}

remove_telemetry_dir()
{
	echo "remove telemetry directory ... "
	rm -r /var/run/telemetry > /dev/null 2>&1
}

remove_notification_dir()
{
	echo "remove notification directory ... "
	rm -r /var/run/notifications_dir > /dev/null 2>&1
}

remove_avira_runtime_dir()
{
	echo "remove runtime directory ... "
	rm -r /var/avira > /dev/null 2>&1
}


remove_guard_dir()
{
	echo "remove guard directory ... "
	rm -r /var/run/avguard/ > /dev/null 2>&1
}

remove_avira_home_application() {
	echo "remove Avira directory from Application Support in the users home directory ... "
	for USERS in $(ls /Users); do
		if [ -z "$USERS" ]; then
			return 0
		fi

		if [ -d /Users/${USERS}/Library/Application\ Support/Avira ]; then
			rm -r /Users/${USERS}/Library/Application\ Support/Avira > /dev/null 2>&1
		fi
	done	
}


remove_product_files()
{
#	remvoe the product main dir /Applications/Avira.app
	rm -r /Applications/Avira.app > /dev/null 2>&1

	remove_db_receipts
	remove_crash_reports
	remove_diagnostic_reports
	remove_private_files
}


remove_users_n_groups()
{
	for AVIRA_USER_N_GROUP in _avuxupdate _avipm
	do
		dscl . ls Users | grep ${AVIRA_USER_N_GROUP} > /dev/null 2>&1
		if [ "${?}" -eq "0" ]
		then
			dscl . delete Users/${AVIRA_USER_N_GROUP} > /dev/null 2>&1
			dscl . delete Groups/${AVIRA_USER_N_GROUP} > /dev/null 2>&1
		fi
	done

	if [ "${KEEP_QUARANTINE}" -eq "0" ]
	then
		dscl . ls Users | grep _avqmd > /dev/null 2>&1
		if [ "${?}" -eq "0" ]
		then
			dscl . delete Users/_avqmd > /dev/null 2>&1
			dscl . delete Groups/_avqmd > /dev/null 2>&1
		fi
	fi
}


run_aims()
{
	if [ ! -x "${UTILITIES_DIR}/aims-client" ]
	then
		return 0
	fi

	if [ -f "${AVDIR_BASE}/guard/avira.key" ]
	then
		KEYFILE="${AVDIR_BASE}/guard/avira.key"
		${UTILITIES_DIR}/aims-client -l ${KEYFILE} uninstall > /dev/null 2>&1
		echo "exitcode: ${?}" >> /dev/null 2>&1
	else
#	  check who is logged on, but not via tty but in gui mode
		LOGGED_ON_USERS_TRASH_LOCATION="/Users/$(who | grep "console" | awk -F' ' '{ print $1 }')/.Trash"
		KEYFILE="${LOGGED_ON_USERS_TRASH_LOCATION}/Avira.app/Contents/guard/avira.key"
		if [ -f "${KEYFILE}" ]
		then
			${UTILITIES_DIR}/aims-client -l ${KEYFILE} uninstall > /dev/null 2>&1
			echo "exitcode: ${?}" >> /dev/null 2>&1
		fi
	fi
}


send_mixpanel_uninstall()
{
	if [ ! -x "${AVSTATS}" ]
	then
		return 0
	fi

	MIXPANEL_PROPERTIES=""
	TRIGGER_VAL="OnDelete"

	if [ "${KEEP_QUARANTINE}" -eq "1" ]
	then
		echo "Keep quarantine"
		MIXPANEL_PROPERTIES="KeepQuarantine:true"
	fi

	if [ "${MANUAL_UNINSTALLATION}" -eq "1" ]
	then
		echo "Keep quarantine"
		TRIGGER_VAL="Manual"
	fi

	MIXPANEL_PROPERTIES="${MIXPANEL_PROPERTIES} Trigger:${TRIGGER_VAL}"

	echo "${AVSTATS} client --eventname Uninstall --payload \"${MIXPANEL_PROPERTIES}\"" > /Library/Application\ Support/Avira/uninstall.log
	${AVSTATS} client --eventname Uninstall --payload "${MIXPANEL_PROPERTIES}" >> /Library/Application\ Support/Avira/uninstall.log 2>&1
	echo $? >> /Library/Application\ Support/Avira/uninstall.log
}


remove_general_files()
{
	rm /Library/Application\ Support/Avira/language > /dev/null 2>&1
	rm /Library/Application\ Support/Avira/aims_install.log > /dev/null 2>&1
	rm -f /Library/Application\ Support/Avira/sauth_install.log > /dev/null 2>&1
	rm -Rf /Library/Application\ Support/Avira/sauth/ 2>&1
}


remove_migration_marker()
{
	rm "$AVIRA_SUPPORT"/framework_migration_done > /dev/null 2>&1
	rm "$AVIRA_SUPPORT"/plugin_migration_done > /dev/null 2>&1
	rm "$AVIRA_SUPPORT"/translation_migration_done > /dev/null 2>&1
}


remove_ftu_supressor()
{
	for USER_DIR in $(ls /Users); do
		if [ -d "/Users/$USER_DIR/Library/Caches/com.avira.controlcenter" ]; then
			rm -r "/Users/$USER_DIR/Library/Caches/com.avira.controlcenter" > /dev/null 2>&1
		fi
	done
}


remove_auth_token()
{
	echo "remove all Avira authentication token ... "
	ALL_AUTH_TOKEN="com.avira.antivirus.update.product_update \
					com.avira.antivirus.avqmd.delete_all \
					com.avira.antivirus.configplugin.write_config \
					com.avira.antivirus.ondemandscannerplugin.whitelist \
					com.avira.antivirus.avrtp.turnonaccessoff"

	for AUTH_TOKEN in $ALL_AUTH_TOKEN; do
		/usr/bin/security authorizationdb read $AUTH_TOKEN > /dev/null 2>&1
		if [ $? -eq 0 ]; then
			/usr/bin/security authorizationdb remove $AUTH_TOKEN > /dev/null 2>&1
		fi
	done
}


remove_utilities_avira()
{
	if [ -d "${UTILITIES_BASE}" ]
	then
		echo "remove Avira Utilities directory ... "
		rm -r ${UTILITIES_BASE} > /dev/null 2>&1
	fi

	if [ -d "${UTILITIES_BASE}-Uninstall.app" ]
	then
		echo "remove Avira-Uninstall.app directory ... "
		rm -r ${UTILITIES_BASE}-Uninstall.app > /dev/null 2>&1
	fi
}


remove_fac()
{
	TRIES="30"

	echo "uninstall FAC module ... "
	while [ "${TRIES}" -gt "0" ]
	do
		kextstat | grep FileAccessControl > /dev/null 2>&1
		if [ "${?}" -eq "1" ]
		then
			break
		fi
		kextunload -b com.avira.kext.FileAccessControl > /dev/null 2>&1

		sleep 1
		TRIES=`expr ${TRIES} - 1`
	done

	# remove legacy
	LEGACY_FAC="/System/Library/Extensions/FileAccessControl.kext"
	if [ -d "$LEGACY_FAC" ]
	then
		rm -r "$LEGACY_FAC" > /dev/null 2>&1
	fi

	CURRENT_FAC="/Library/Extensions/FileAccessControl.kext"
	if [ -d "$CURRENT_FAC" ]
	then
		rm -r "$CURRENT_FAC" > /dev/null 2>&1
	fi

	rm -rf /System/Library/Caches/com.apple.kext.caches/ > /dev/null 2>&1
}


# main()
	for PARAMETER in "${@}"
	do
		case ${PARAMETER} in
			--keep-quarantine)
				KEEP_QUARANTINE="1"
				;;
		esac
		case ${PARAMETER} in
			--manual)
				MANUAL_UNINSTALLATION="1"
				;;
		esac
	done

#	check if the user is root
	root_check

#	call mixpanel
	send_mixpanel_uninstall

#	shutdown the gui
	shutdown_gui
	shutdown_scheduler

#	check if there are plist files and remove them
	remove_launcha_entries
	remove_launchd_entries
	check_for_remaining_processes

# empty some generated directories
	remove_quarantine_dir
	remove_logwriter_dir
	remove_update_dir
	remove_ipm_dir
	remove_telemetry_dir
	remove_notification_dir
	remove_avwl_dir
	remove_avira_runtime_dir
	remove_guard_dir

#	remove files from /Users/USERNAME/Library/Application Support/Avira
	remove_avira_home_application

#	run aims at uninstall time
	run_aims

#	remove some files in /var/lib/com.avira.antivirus.general
	remove_general_files

#	remove migration marker
	remove_migration_marker

#	remove the ftu supressor files from the users home dir + dir
	remove_ftu_supressor

#	remove the authentication tokes we create for our product
	remove_auth_token

#	remove the product files and directories
	remove_product_files

#	remove the avira groups and users
	remove_users_n_groups

#	unload and remove the fac
	remove_fac

#	remove files from utilities/avira
	remove_utilities_avira

	echo " "
	echo "You have successfully uninstalled ${FULLPRODUCTNAME}"

